/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.combat;

import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.inventory.EnchantmentUtility;
import Krasnodar.rockstarnew.utility.mixins.ArmorItemAddition;
import Krasnodar.rockstarnew.utility.time.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_5321;
import net.minecraft.class_8051;

@ModuleInfo(name="Auto Armor", category=ModuleCategory.COMBAT, desc="modules.descriptions.auto_armor")
public class AutoArmor
extends BaseModule {
    private final Timer timer = new Timer();
    private SliderSetting delay;
    private final EventListener<ClientPlayerTickEvent> onClientPlayerTickEvent = event -> {
        class_1661 inventory = AutoArmor.mc.field_1724.method_31548();
        int[] bestArmorSlots = new int[4];
        int[] bestArmorValues = new int[4];
        this.evaluateCurrentArmorValues(inventory, bestArmorSlots, bestArmorValues);
        ArrayList<Integer> types = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3));
        Collections.shuffle(types);
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            class_1799 oldArmor;
            int i = (Integer)iterator.next();
            int bestSlot = bestArmorSlots[i];
            if (bestSlot == -1 || !(oldArmor = inventory.method_7372(i)).method_7960() && inventory.method_7376() == -1) continue;
            this.transferArmorItem(inventory, bestSlot, i);
            break;
        }
    };

    private void initialize() {
        this.delay = new SliderSetting(this, "delay").min(50.0f).max(1000.0f).step(1.0f).currentValue(250.0f).suffix(" ms");
    }

    public AutoArmor() {
        this.initialize();
    }

    private void evaluateCurrentArmorValues(class_1661 inventory, int[] bestArmorSlots, int[] bestArmorValues) {
        class_1738 item;
        class_1792 class_17922;
        class_1799 stack;
        for (int type = 0; type < 4; ++type) {
            bestArmorSlots[type] = -1;
            stack = inventory.method_7372(type);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1738)) continue;
            item = (class_1738)class_17922;
            bestArmorValues[type] = this.getArmorValue(item, stack);
        }
        block7: for (int slot = 0; slot < 36; ++slot) {
            int armorType;
            stack = inventory.method_5438(slot);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof class_1738)) continue;
            item = (class_1738)class_17922;
            class_1304 equipmentSlot = ((ArmorItemAddition)item).rockstar$getType().method_48399();
            switch (equipmentSlot) {
                case field_6169: {
                    armorType = 3;
                    break;
                }
                case field_6174: {
                    armorType = 2;
                    break;
                }
                case field_6172: {
                    armorType = 1;
                    break;
                }
                case field_6166: {
                    armorType = 0;
                    break;
                }
                default: {
                    continue block7;
                }
            }
            int armorValue = this.getArmorValue(item, stack);
            if (armorValue <= bestArmorValues[armorType]) continue;
            bestArmorSlots[armorType] = slot;
            bestArmorValues[armorType] = armorValue;
        }
    }

    private void transferArmorItem(class_1661 inventory, int bestSlot, int armorType) {
        if (bestSlot < 9) {
            bestSlot += 36;
        }
        if (this.timer.finished((long)this.delay.getCurrentValue())) {
            class_1799 oldArmor = inventory.method_7372(armorType);
            if (!oldArmor.method_7960()) {
                AutoArmor.mc.field_1761.method_2906(0, 8 - armorType, 0, class_1713.field_7794, (class_1657)AutoArmor.mc.field_1724);
            }
            AutoArmor.mc.field_1761.method_2906(0, bestSlot, 0, class_1713.field_7794, (class_1657)AutoArmor.mc.field_1724);
            this.timer.reset();
        }
    }

    private int getArmorValue(class_1738 item, class_1799 stack) {
        class_1741 material = ((ArmorItemAddition)item).rockstar$getMaterial();
        class_8051 equipmentType = ((ArmorItemAddition)item).rockstar$getType();
        int armorPoints = material.comp_2298().getOrDefault(equipmentType, 0);
        int armorToughness = (int)material.comp_2303();
        int protectionLevel = EnchantmentUtility.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9111);
        return armorPoints * 5 + protectionLevel * 3 + armorToughness;
    }
}

